/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.mixin.common.position_sync;

import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2708;
import net.minecraft.class_2709;
import net.minecraft.class_2793;
import net.minecraft.class_2828;
import net.minecraft.class_2848;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import qouteall.imm_ptl.core.IPGlobal;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEPlayerMoveC2SPacket;
import qouteall.imm_ptl.core.ducks.IEPlayerPositionLookS2CPacket;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.teleportation.ServerTeleportationManager;
import qouteall.q_misc_util.my_util.CountDownInt;

@Mixin(value={class_3244.class}, priority=900)
public abstract class MixinServerGamePacketListenerImpl
implements IEServerPlayNetworkHandler {
    @Shadow
    public class_3222 field_14140;
    @Shadow
    private class_243 field_14119;
    @Shadow
    private int field_14123;
    @Shadow
    private int field_14139;
    @Shadow
    private int field_14118;
    @Shadow
    private double field_14122;
    @Shadow
    private double field_14141;
    @Shadow
    private double field_14120;
    @Shadow
    private double field_14143;
    @Shadow
    private double field_14124;
    @Shadow
    private double field_14142;
    @Shadow
    private class_1297 field_14147;
    @Shadow
    private boolean field_14129;
    @Shadow
    @Final
    static Logger field_14121;
    @Shadow
    private boolean field_14131;
    @Unique
    private static final CountDownInt LOG_LIMIT;
    @Unique
    private int ip_wrongMovePacketCount = 0;
    @Unique
    @Nullable
    private class_5321<class_1937> ip_dimOfAwaitingPosition;

    @Shadow
    public abstract class_3222 method_32311();

    @Inject(method={"Lnet/minecraft/server/network/ServerGamePacketListenerImpl;handleMovePlayer(Lnet/minecraft/network/protocol/game/ServerboundMovePlayerPacket;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/network/protocol/PacketUtils;ensureRunningOnSameThread(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketListener;Lnet/minecraft/server/level/ServerLevel;)V")}, cancellable=true)
    private void onProcessMovePacket(class_2828 packet, CallbackInfo ci) {
        class_5321<class_1937> packetDimension = ((IEPlayerMoveC2SPacket)packet).ip_getPlayerDimension();
        if (packetDimension == null) {
            field_14121.error("Player move packet is missing dimension info. Maybe the player client doesn't install iPortal");
            ServerTaskList.of(this.field_14140.field_13995).addTask(() -> {
                this.field_14140.field_13987.method_52396((class_2561)class_2561.method_43470((String)"The client does not have Immersive Portals mod"));
                return true;
            });
            return;
        }
        if (this.field_14140.method_37908().method_27983() != packetDimension) {
            if (LOG_LIMIT.tryDecrement()) {
                field_14121.info("[ImmPtl] Ignoring player move packet. Player: {} Packet: {} {} {} {}", new Object[]{this.field_14140, packetDimension.method_29177(), packet.method_12269(this.field_14140.method_23317()), packet.method_12268(this.field_14140.method_23318()), packet.method_12274(this.field_14140.method_23321())});
            }
            ++this.ip_wrongMovePacketCount;
            if (this.ip_wrongMovePacketCount > 10) {
                field_14121.info("[ImmPtl] Force move player {} {} {}", new Object[]{this.field_14140, this.field_14140.method_37908().method_27983().method_29177(), this.field_14140.method_19538()});
                ServerTeleportationManager.of(this.field_14140.field_13995).forceTeleportPlayer(this.field_14140, (class_5321<class_1937>)this.field_14140.method_37908().method_27983(), this.field_14140.method_19538());
                this.ip_wrongMovePacketCount = 0;
            }
            ci.cancel();
        } else {
            this.ip_wrongMovePacketCount = 0;
        }
    }

    @Overwrite
    @IPVanillaCopy
    public void method_14360(double x, double y, double z, float yaw, float pitch, Set<class_2709> relativeAttrs) {
        if (this.field_14140.method_35049() != null) {
            field_14121.error("[ImmPtl] Tries to send player pos packet to a removed player {}", (Object)this.field_14140, (Object)new Throwable());
            return;
        }
        if (IPConfig.getConfig().serverTeleportLogging) {
            field_14121.info("Teleporting player {} to {} {} {} {}", new Object[]{this.field_14140, this.field_14140.method_37908().method_27983().method_29177(), x, y, z});
        }
        double xBase = relativeAttrs.contains(class_2709.field_12400) ? this.field_14140.method_23317() : 0.0;
        double yBase = relativeAttrs.contains(class_2709.field_12398) ? this.field_14140.method_23318() : 0.0;
        double zBase = relativeAttrs.contains(class_2709.field_12403) ? this.field_14140.method_23321() : 0.0;
        float yRotBase = relativeAttrs.contains(class_2709.field_12401) ? this.field_14140.method_36454() : 0.0f;
        float xRotBase = relativeAttrs.contains(class_2709.field_12397) ? this.field_14140.method_36455() : 0.0f;
        this.field_14119 = new class_243(x, y, z);
        this.ip_dimOfAwaitingPosition = this.field_14140.method_37908().method_27983();
        if (++this.field_14123 == Integer.MAX_VALUE) {
            this.field_14123 = 0;
        }
        this.field_14139 = this.field_14118;
        this.field_14140.method_5641(x, y, z, yaw, pitch);
        class_2708 lookPacket = new class_2708(x - xBase, y - yBase, z - zBase, yaw - yRotBase, pitch - xRotBase, relativeAttrs, this.field_14123);
        ((IEPlayerPositionLookS2CPacket)lookPacket).ip_setPlayerDimension((class_5321<class_1937>)this.field_14140.method_37908().method_27983());
        this.field_14140.field_13987.method_14364((class_2596)lookPacket);
    }

    @Inject(method={"isPlayerCollidingWithAnythingNew"}, at={@At(value="HEAD")}, cancellable=true)
    private void onIsPlayerCollidingWithAnythingNew(class_4538 level, class_238 playerBB, double newX, double newY, double newZ, CallbackInfoReturnable<Boolean> cir) {
        if (!IPGlobal.crossPortalCollision) {
            return;
        }
        class_238 activePlayerBB = ((IEEntity)this.field_14140).ip_getActiveCollisionBox(playerBB);
        if (activePlayerBB == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        class_238 newBB = this.field_14140.method_5829().method_989(newX - this.field_14140.method_23317(), newY - this.field_14140.method_23318(), newZ - this.field_14140.method_23321());
        class_238 activeNewBB = ((IEEntity)this.field_14140).ip_getActiveCollisionBox(newBB);
        if (activeNewBB == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        Iterable newBBCollisions = level.method_8600((class_1297)this.field_14140, activeNewBB.method_1011((double)1.0E-5f));
        class_265 activePlayerBBShape = class_259.method_1078((class_238)activePlayerBB.method_1011((double)1.0E-5f));
        for (class_265 shape : newBBCollisions) {
            if (class_259.method_1074((class_265)shape, (class_265)activePlayerBBShape, (class_247)class_247.field_16896)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (((IEEntity)this.field_14140).ip_isRecentlyCollidingWithPortal()) {
            this.field_14131 = false;
        }
    }

    @Inject(method={"handleAcceptTeleportPacket"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;absMoveTo(DDDFF)V")})
    private void onHandleAcceptTeleportPacket(class_2793 packet, CallbackInfo ci) {
        if (this.ip_dimOfAwaitingPosition == null) {
            field_14121.error("[ImmPtl] ip_dimOfAwaitingPosition is null {}", (Object)this.field_14140);
            return;
        }
        if (this.ip_dimOfAwaitingPosition != this.field_14140.method_37908().method_27983()) {
            field_14121.info("Accepted teleport to another dimension {} {}", this.ip_dimOfAwaitingPosition, (Object)this.field_14119);
            class_3218 destWorld = this.field_14140.field_13995.method_3847(this.ip_dimOfAwaitingPosition);
            if (destWorld == null) {
                field_14121.error("[ImmPtl] Cannot find destination world {}", (Object)this.ip_dimOfAwaitingPosition.method_29177());
                return;
            }
            ServerTeleportationManager.of(this.field_14140.field_13995).forceTeleportPlayer(this.field_14140, this.ip_dimOfAwaitingPosition, this.field_14119, false);
            this.ip_dimOfAwaitingPosition = null;
        }
    }

    @Inject(method={"handlePlayerCommand"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerGamePacketListenerImpl;awaitingPositionFromClient:Lnet/minecraft/world/phys/Vec3;", opcode=181)})
    private void onTeleportPlayerCancelSleeping(class_2848 packet, CallbackInfo ci) {
        this.ip_dimOfAwaitingPosition = this.field_14140.method_37908().method_27983();
    }

    @Override
    public boolean ip_hasAwaitingTeleport() {
        return this.field_14119 != null;
    }

    static {
        LOG_LIMIT = new CountDownInt(20);
    }
}

